<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Lms_admin extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('lms_lite_model');
    }

    public function schools()
    {
        if (!has_permission('lms_lite', '', 'view')) {
            access_denied('lms_lite');
        }

        $data['title'] = _l('lms_schools');
        $data['schools'] = json_decode(get_option('lms_lite_schools_data'), true) ?: [];
        $this->load->view('admin/lms_lite/schools', $data);
    }

    public function users()
    {
        if (!has_permission('lms_lite', '', 'view')) {
            access_denied('lms_lite');
        }

        $data['title'] = _l('lms_users');
        $data['enrollments'] = $this->lms_lite_model->get_all_enrollments();
        $this->load->view('admin/lms_lite/users', $data);
    }

    public function save_schools()
    {
        if (!has_permission('lms_lite', '', 'edit')) {
            access_denied('lms_lite');
        }

        if ($this->input->post()) {
            $schools = $this->input->post('schools');
            update_option('lms_lite_schools_data', json_encode($schools));
            set_alert('success', _l('settings_updated'));
        }

        redirect(admin_url('lms_admin/schools'));
    }
}
