<?php defined('BASEPATH') or exit('No direct script access allowed');

class Lms_portal extends ClientsController {
    
    public function __construct() {
        parent::__construct();
        $this->load->model('lms_courses_model');
        $this->load->model('lms_lectures_model');
        $this->load->model('lms_enrollments_model');
        $this->load->model('lms_orders_model');
    }
    
    public function index() {
        $data['q'] = $this->input->get('q');
        $data['category'] = $this->input->get('category');
        $page = (int)$this->input->get('page') ?: 1;
        $limit = 20;
        $offset = ($page - 1) * $limit;
        
        $data['courses'] = $this->lms_courses_model->get_catalog($data['q'], $data['category'], $limit, $offset);
        $data['total'] = $this->lms_courses_model->count_catalog($data['q'], $data['category']);
        $data['pagination'] = $this->get_pagination($data['total'], $limit, $page);
        
        $this->data($data);
        $this->view('portal/catalog');
        $this->layout();
    }
    
    public function course($slug) {
        $course = $this->lms_courses_model->get_by_slug($slug);
        if (!$course) {
            show_404();
        }
        
        $data['course'] = $course;
        $data['lectures'] = $this->lms_lectures_model->get_for_course($course->id);
        $data['is_enrolled'] = false;
        
        if (is_client_logged_in()) {
            $data['is_enrolled'] = $this->lms_enrollments_model->is_enrolled(get_client_user_id(), $course->id);
        }
        
        $this->data($data);
        $this->view('portal/course_detail');
        $this->layout();
    }
    
    public function checkout() {
        if (!is_client_logged_in()) {
            redirect('authentication/login');
        }
        
        if ($this->input->post()) {
            $course_id = $this->input->post('course_id');
            $course = $this->lms_courses_model->get($course_id);
            
            if ($course) {
                $order_data = [
                    'client_id' => get_client_user_id(),
                    'course_id' => $course_id,
                    'amount' => $course->price,
                    'payment_status' => 'paid'
                ];
                
                $order_id = $this->lms_orders_model->create_order($order_data);
                
                if ($order_id) {
                    $months = get_option('lms_lite_default_enrollment_months');
                    $this->lms_enrollments_model->create_enrollment(get_client_user_id(), $course_id, $months);
                    set_alert('success', 'Enrollment successful!');
                    redirect('lms/account/enrollments');
                }
            }
        }
        
        $course_id = $this->input->get('course_id');
        $data['course'] = $this->lms_courses_model->get($course_id);
        
        $this->data($data);
        $this->view('portal/checkout');
        $this->layout();
    }
    
    public function account($page = 'enrollments') {
        if (!is_client_logged_in()) {
            redirect('authentication/login');
        }
        
        switch($page) {
            case 'enrollments':
                $data['enrollments'] = $this->lms_enrollments_model->get_my_enrollments(get_client_user_id());
                $this->data($data);
                $this->view('portal/account_enrollments');
                break;
                
            case 'orders':
                $data['orders'] = $this->lms_orders_model->get_my_orders(get_client_user_id());
                $this->data($data);
                $this->view('portal/account_orders');
                break;
                
            case 'profile':
                $this->view('portal/account_profile');
                break;
                
            case 'wishlist':
                $wishlist = $this->session->userdata('lms_wishlist') ?: [];
                $data['wishlist_courses'] = [];
                if (!empty($wishlist)) {
                    $data['wishlist_courses'] = $this->lms_courses_model->get_by_ids($wishlist);
                }
                $this->data($data);
                $this->view('portal/account_wishlist');
                break;
        }
        
        $this->layout();
    }
    
    public function learn($course_id, $lecture_id) {
        if (!is_client_logged_in()) {
            redirect('authentication/login');
        }
        
        if (!$this->lms_enrollments_model->is_enrolled(get_client_user_id(), $course_id)) {
            redirect('lms');
        }
        
        $this->lms_enrollments_model->start_enrollment_if_needed(get_client_user_id(), $course_id);
        
        $data['course'] = $this->lms_courses_model->get($course_id);
        $data['lecture'] = $this->lms_lectures_model->get($lecture_id);
        $data['nav'] = $this->lms_lectures_model->get_next_prev($course_id, $lecture_id);
        
        $this->data($data);
        $this->view('portal/player');
        $this->layout();
    }
    
    public function wishlist_toggle() {
        if (!$this->input->is_ajax_request()) {
            show_404();
        }
        
        $course_id = $this->input->post('course_id');
        $wishlist = $this->session->userdata('lms_wishlist') ?: [];
        
        if (in_array($course_id, $wishlist)) {
            $wishlist = array_diff($wishlist, [$course_id]);
            $action = 'removed';
        } else {
            $wishlist[] = $course_id;
            $action = 'added';
        }
        
        $this->session->set_userdata('lms_wishlist', $wishlist);
        
        echo json_encode(['status' => 'success', 'action' => $action]);
    }
    
    private function get_pagination($total, $limit, $page) {
        $pages = ceil($total / $limit);
        return [
            'current' => $page,
            'total' => $pages,
            'has_prev' => $page > 1,
            'has_next' => $page < $pages,
            'prev' => $page - 1,
            'next' => $page + 1
        ];
    }
}