<?php defined('BASEPATH') or exit('No direct script access allowed');

$CI       = &get_instance();
$charset  = $CI->db->char_set;
$collate  = $CI->db->dbcollat;

/** Courses **/
$CI->db->query('CREATE TABLE IF NOT EXISTS `'.db_prefix().'lms_courses` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) NOT NULL,
  `short_desc` TEXT NULL,
  `thumb` VARCHAR(255) NULL,
  `price` DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  `status` ENUM("active","inactive") NOT NULL DEFAULT "active",
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_slug` (`slug`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET='.$charset.' COLLATE='.$collate.';');

/** Lectures **/
$CI->db->query('CREATE TABLE IF NOT EXISTS `'.db_prefix().'lms_lectures` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `course_id` INT(11) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `sort_order` INT(11) NOT NULL DEFAULT 0,
  `vimeo_url` VARCHAR(255) NULL,
  `duration_sec` INT(11) NULL,
  PRIMARY KEY (`id`),
  KEY `idx_course_id` (`course_id`),
  KEY `idx_sort_order` (`sort_order`),
  CONSTRAINT `fk_lectures_course` FOREIGN KEY (`course_id`)
    REFERENCES `'.db_prefix().'lms_courses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET='.$charset.' COLLATE='.$collate.';');

/** Enrollments **/
$CI->db->query('CREATE TABLE IF NOT EXISTS `'.db_prefix().'lms_enrollments` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `client_id` INT(11) NOT NULL,
  `course_id` INT(11) NOT NULL,
  `start_date` DATE NULL,  -- store YYYY-MM-01
  `end_date` DATE NULL,    -- store YYYY-MM-01
  `progress_pct` TINYINT(3) NOT NULL DEFAULT 0,
  `status` VARCHAR(30) NOT NULL DEFAULT "active",
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_course_id` (`course_id`),
  KEY `idx_status` (`status`),
  CONSTRAINT `fk_enrollments_course` FOREIGN KEY (`course_id`)
    REFERENCES `'.db_prefix().'lms_courses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET='.$charset.' COLLATE='.$collate.';');

/** Orders **/
$CI->db->query('CREATE TABLE IF NOT EXISTS `'.db_prefix().'lms_orders` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `client_id` INT(11) NOT NULL,
  `course_id` INT(11) NOT NULL,
  `amount` DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  `payment_status` VARCHAR(50) NOT NULL DEFAULT "pending",
  `invoice_id` INT(11) NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_course_id` (`course_id`),
  KEY `idx_payment_status` (`payment_status`)
) ENGINE=InnoDB DEFAULT CHARSET='.$charset.' COLLATE='.$collate.';');

/** Options used by module **/
add_option('lms_lite_logo_school_url', '');
add_option('lms_lite_logo_knowledge_url', '');
add_option('lms_lite_default_enrollment_months', 12);
