
<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: LMS Lite
Description: Lightweight Learning Management System for Perfex CRM
Version: 1.0.0
Author: Perfex CRM Module
Requires at least: 2.3.*
*/

define('LMS_LITE_MODULE_NAME', 'lms_lite');

// Register activation and deactivation hooks
register_activation_hook(LMS_LITE_MODULE_NAME, 'lms_lite_activation_hook');
register_deactivation_hook(LMS_LITE_MODULE_NAME, 'lms_lite_deactivation_hook');

function lms_lite_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

function lms_lite_deactivation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/uninstall.php');
}

// Initialize the module
hooks()->add_action('app_init', 'lms_lite_init');

function lms_lite_init()
{
    $CI = &get_instance();
    $CI->load->helper('lms_lite');
}

// Add CSS files
hooks()->add_action('app_admin_head', 'lms_lite_admin_head');
hooks()->add_action('app_clients_head', 'lms_lite_client_head');

function lms_lite_admin_head()
{
    echo '<link href="' . module_dir_url('lms_lite', 'assets/css/lms.css') . '" rel="stylesheet" type="text/css">';
}

function lms_lite_client_head()
{
    echo '<link href="' . module_dir_url('lms_lite', 'assets/css/lms.css') . '" rel="stylesheet" type="text/css">';
}

// Admin menu initialization
hooks()->add_action('admin_init', 'lms_lite_admin_init');

function lms_lite_admin_init()
{
    $CI = &get_instance();
    
    if (has_permission('lms_lite', '', 'view')) {
        $CI->app_menu->add_sidebar_menu_item('lms_lite', [
            'name' => 'LMS Lite',
            'position' => 35,
            'icon' => 'fa fa-graduation-cap',
            'href' => admin_url('lms_admin/schools'),
        ]);
        
        $CI->app_menu->add_sidebar_children_item('lms_lite', [
            'slug' => 'lms-schools',
            'name' => 'Schools',
            'href' => admin_url('lms_admin/schools'),
        ]);
        
        $CI->app_menu->add_sidebar_children_item('lms_lite', [
            'slug' => 'lms-users',
            'name' => 'Users',
            'href' => admin_url('lms_admin/users'),
        ]);
    }
}

// Client menu initialization
hooks()->add_action('clients_init', 'lms_lite_client_init');

function lms_lite_client_init()
{
    $CI = &get_instance();
    
    $CI->app_menu->add_sidebar_menu_item('lms_catalog', [
        'name' => 'Course Catalog',
        'href' => site_url('lms'),
        'position' => 10,
        'icon' => 'fa fa-book',
    ]);
    
    if (is_client_logged_in()) {
        $CI->app_menu->add_sidebar_menu_item('lms_enrollments', [
            'name' => 'My Enrollments',
            'href' => site_url('lms/account/enrollments'),
            'position' => 11,
            'icon' => 'fa fa-graduation-cap',
        ]);
        
        $CI->app_menu->add_sidebar_menu_item('lms_orders', [
            'name' => 'Orders',
            'href' => site_url('lms/account/orders'),
            'position' => 12,
            'icon' => 'fa fa-shopping-cart',
        ]);
        
        $CI->app_menu->add_sidebar_menu_item('lms_wishlist', [
            'name' => 'Wishlist',
            'href' => site_url('lms/account/wishlist'),
            'position' => 13,
            'icon' => 'fa fa-heart',
        ]);
    }
}

// Register permissions
$CI = &get_instance();
if (isset($CI->app_modules) && method_exists($CI->app_modules, 'add_action_hook')) {
    $CI->app_modules->add_action_hook('lms_lite', 'module_lms_lite_action_links');
}

function module_lms_lite_action_links($actions)
{
    $actions[] = '<a href="' . admin_url('lms_admin/schools') . '">Settings</a>';
    return $actions;
}

 
 