<?php defined('BASEPATH') or exit('No direct script access allowed');

class Lms_courses_model extends App_Model {
    
    public function __construct() {
        parent::__construct();
        $this->table = db_prefix() . 'lms_courses';
    }
    
    public function get_catalog($q = null, $category = null, $limit = 20, $offset = 0) {
        $this->db->where('status', 'active');
        
        if ($q) {
            $this->db->group_start();
            $this->db->like('title', $q);
            $this->db->or_like('short_desc', $q);
            $this->db->group_end();
        }
        
        $this->db->limit($limit, $offset);
        $this->db->order_by('created_at', 'DESC');
        
        return $this->db->get($this->table)->result();
    }
    
    public function count_catalog($q = null, $category = null) {
        $this->db->where('status', 'active');
        
        if ($q) {
            $this->db->group_start();
            $this->db->like('title', $q);
            $this->db->or_like('short_desc', $q);
            $this->db->group_end();
        }
        
        return $this->db->count_all_results($this->table);
    }
    
    public function get_by_slug($slug) {
        return $this->db->where('slug', $slug)->where('status', 'active')->get($this->table)->row();
    }
    
    public function get_by_ids($ids) {
        if (empty($ids)) return [];
        
        $this->db->where_in('id', $ids);
        $this->db->where('status', 'active');
        return $this->db->get($this->table)->result();
    }
    
    public function add($data) {
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');
        
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }
    
    public function update($id, $data) {
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }
}