<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><?php echo $title; ?></h3>
            </div>
            <div class="panel-body">
                <?php if (empty($enrollments)) { ?>
                    <p><?php echo _l('no_enrollments_found'); ?></p>
                    <a href="<?php echo site_url('lms'); ?>" class="btn btn-primary"><?php echo _l('browse_courses'); ?></a>
                <?php } else { ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th><?php echo _l('course'); ?></th>
                                    <th><?php echo _l('progress'); ?></th>
                                    <th><?php echo _l('start_date'); ?></th>
                                    <th><?php echo _l('end_date'); ?></th>
                                    <th><?php echo _l('actions'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($enrollments as $enrollment) { ?>
                                    <tr>
                                        <td>
                                            <?php if ($enrollment['thumb']) { ?>
                                                <img src="<?php echo $enrollment['thumb']; ?>" class="enrollment-thumb" alt="">
                                            <?php } ?>
                                            <?php echo $enrollment['course_title']; ?>
                                        </td>
                                        <td>
                                            <div class="progress">
                                                <div class="progress-bar" style="width: <?php echo $enrollment['progress_pct']; ?>%"></div>
                                            </div>
                                            <?php echo $enrollment['progress_pct']; ?>%
                                        </td>
                                        <td><?php echo _d($enrollment['start_date']); ?></td>
                                        <td><?php echo _d($enrollment['end_date']); ?></td>
                                        <td>
                                            <a href="<?php echo site_url('lms/player/' . $enrollment['course_slug']); ?>" class="btn btn-primary btn-sm">
                                                <?php echo _l('continue_learning'); ?>
                                            </a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>