<?php defined('BASEPATH') or exit('No direct script access allowed');

class Lms_lectures_model extends App_Model {
    
    public function __construct() {
        parent::__construct();
        $this->table = db_prefix() . 'lms_lectures';
    }
    
    public function get_for_course($course_id) {
        $this->db->where('course_id', $course_id);
        $this->db->order_by('sort_order', 'ASC');
        return $this->db->get($this->table)->result();
    }
    
    public function get_next_prev($course_id, $lecture_id) {
        $current = $this->db->where('id', $lecture_id)->get($this->table)->row();
        if (!$current) return ['prev' => null, 'next' => null];
        
        $prev = $this->db->where('course_id', $course_id)
                        ->where('sort_order <', $current->sort_order)
                        ->order_by('sort_order', 'DESC')
                        ->limit(1)
                        ->get($this->table)->row();
                        
        $next = $this->db->where('course_id', $course_id)
                        ->where('sort_order >', $current->sort_order)
                        ->order_by('sort_order', 'ASC')
                        ->limit(1)
                        ->get($this->table)->row();
        
        return ['prev' => $prev, 'next' => $next];
    }
    
    public function add($data) {
        return $this->db->insert($this->table, $data);
    }
    
    public function update($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }
}