<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Lms_lite_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // Course methods
    public function get_courses($where = [])
    {
        if (!empty($where)) {
            $this->db->where($where);
        }
        
        return $this->db->order_by('created_at', 'DESC')
                       ->get(db_prefix() . 'lms_courses')
                       ->result_array();
    }

    public function get_active_courses()
    {
        return $this->get_courses(['status' => 'active']);
    }

    public function get_course($id)
    {
        return $this->db->where('id', $id)
                       ->get(db_prefix() . 'lms_courses')
                       ->row_array();
    }

    public function get_course_by_slug($slug)
    {
        return $this->db->where('slug', $slug)
                       ->get(db_prefix() . 'lms_courses')
                       ->row_array();
    }

    public function get_courses_by_ids($ids)
    {
        if (empty($ids)) {
            return [];
        }
        
        return $this->db->where_in('id', $ids)
                       ->where('status', 'active')
                       ->get(db_prefix() . 'lms_courses')
                       ->result_array();
    }

    // Lecture methods
    public function get_course_lectures($course_id)
    {
        return $this->db->where('course_id', $course_id)
                       ->order_by('sort_order', 'ASC')
                       ->get(db_prefix() . 'lms_lectures')
                       ->result_array();
    }

    // Enrollment methods
    public function get_all_enrollments()
    {
        $this->db->select('e.*, c.title as course_title, cont.firstname, cont.lastname, cont.email')
                 ->from(db_prefix() . 'lms_enrollments e')
                 ->join(db_prefix() . 'lms_courses c', 'c.id = e.course_id')
                 ->join(db_prefix() . 'contacts cont', 'cont.id = e.client_id');
        
        return $this->db->order_by('e.created_at', 'DESC')
                       ->get()
                       ->result_array();
    }

    public function get_client_enrollments($client_id)
    {
        $this->db->select('e.*, c.title as course_title, c.slug as course_slug, c.thumb')
                 ->from(db_prefix() . 'lms_enrollments e')
                 ->join(db_prefix() . 'lms_courses c', 'c.id = e.course_id')
                 ->where('e.client_id', $client_id);
        
        return $this->db->order_by('e.created_at', 'DESC')
                       ->get()
                       ->result_array();
    }

    public function is_client_enrolled($client_id, $course_id)
    {
        $enrollment = $this->db->where([
            'client_id' => $client_id,
            'course_id' => $course_id,
            'status' => 'active',
            'start_date <=' => date('Y-m-d'),
            'end_date >=' => date('Y-m-d')
        ])->get(db_prefix() . 'lms_enrollments')->row_array();
        
        return !empty($enrollment);
    }

    public function add_enrollment($data)
    {
        $this->db->insert(db_prefix() . 'lms_enrollments', $data);
        return $this->db->insert_id();
    }

    // Order methods
    public function get_client_orders($client_id)
    {
        $this->db->select('o.*, c.title as course_title, c.slug as course_slug')
                 ->from(db_prefix() . 'lms_orders o')
                 ->join(db_prefix() . 'lms_courses c', 'c.id = o.course_id')
                 ->where('o.client_id', $client_id);
        
        return $this->db->order_by('o.created_at', 'DESC')
                       ->get()
                       ->result_array();
    }

    public function add_order($data)
    {
        $this->db->insert(db_prefix() . 'lms_orders', $data);
        return $this->db->insert_id();
    }
}