<?php defined('BASEPATH') or exit('No direct script access allowed');

class Lms_orders_model extends App_Model {
    
    public function __construct() {
        parent::__construct();
        $this->table = db_prefix() . 'lms_orders';
    }
    
    public function create_order($data) {
        $data['created_at'] = date('Y-m-d H:i:s');
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }
    
    public function get_my_orders($client_id) {
        $this->db->select('o.*, c.title, c.slug');
        $this->db->from($this->table . ' o');
        $this->db->join(db_prefix() . 'lms_courses c', 'c.id = o.course_id');
        $this->db->where('o.client_id', $client_id);
        $this->db->order_by('o.created_at', 'DESC');
        
        return $this->db->get()->result();
    }
    
    public function update_payment_status($order_id, $status) {
        $this->db->where('id', $order_id);
        return $this->db->update($this->table, ['payment_status' => $status]);
    }
}