<?php

defined('BASEPATH') or exit('No direct script access allowed');

$CI = &get_instance();

// Disable foreign key checks to avoid constraint issues
$CI->db->query('SET foreign_key_checks = 0');

try {
    // Drop tables in reverse order to handle any remaining foreign keys
    $tables = [
        db_prefix() . 'lms_orders',
        db_prefix() . 'lms_enrollments', 
        db_prefix() . 'lms_lectures',
        db_prefix() . 'lms_courses'
    ];
    
    foreach ($tables as $table) {
        if ($CI->db->table_exists($table)) {
            $CI->db->query("DROP TABLE `$table`");
        }
    }

    // Remove options
    $options = [
        'lms_lite_logo_school_url',
        'lms_lite_logo_knowledge_url', 
        'lms_lite_default_enrollment_months',
        'lms_lite_schools_data'
    ];
    
    foreach ($options as $option) {
        delete_option($option);
    }

    // Remove permissions
    if ($CI->db->table_exists(db_prefix() . 'staff_permissions')) {
        $CI->db->where('feature', 'lms_lite')->delete(db_prefix() . 'staff_permissions');
    }

} catch (Exception $e) {
    log_message('error', 'LMS Lite uninstall error: ' . $e->getMessage());
} finally {
    // Re-enable foreign key checks
    $CI->db->query('SET foreign_key_checks = 1');
}