?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin"><?php echo $title; ?></h4>
                        <hr class="hr-panel-separator" />
                        
                        <div class="table-responsive">
                            <table class="table dt-table">
                                <thead>
                                    <tr>
                                        <th><?php echo _l('contact'); ?></th>
                                        <th><?php echo _l('course'); ?></th>
                                        <th><?php echo _l('progress'); ?></th>
                                        <th><?php echo _l('start_date'); ?></th>
                                        <th><?php echo _l('end_date'); ?></th>
                                        <th><?php echo _l('status'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($enrollments as $enrollment) { ?>
                                        <tr>
                                            <td><?php echo $enrollment['firstname'] . ' ' . $enrollment['lastname']; ?></td>
                                            <td><?php echo $enrollment['course_title']; ?></td>
                                            <td><?php echo $enrollment['progress_pct']; ?>%</td>
                                            <td><?php echo _d($enrollment['start_date']); ?></td>
                                            <td><?php echo _d($enrollment['end_date']); ?></td>
                                            <td>
                                                <span class="label label-<?php echo $enrollment['status'] == 'active' ? 'success' : 'default'; ?>">
                                                    <?php echo ucfirst($enrollment['status']); ?>
                                                </span>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
