<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel panel-default">
    <div class="panel-body">
        <h3>My Enrollments</h3>
        
        <?php if (!empty($enrollments)): ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Course</th>
                            <th>Start Month</th>
                            <th>End Month</th>
                            <th>Progress</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($enrollments as $enrollment): ?>
                            <tr>
                                <td>
                                    <strong><?php echo html_escape($enrollment->title); ?></strong>
                                </td>
                                <td>
                                    <?php echo $enrollment->start_date ? date('Y-m', strtotime($enrollment->start_date)) : 'Not started'; ?>
                                </td>
                                <td>
                                    <?php echo $enrollment->end_date ? date('Y-m', strtotime($enrollment->end_date)) : 'N/A'; ?>
                                </td>
                                <td>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: <?php echo $enrollment->progress_pct; ?>%">
                                            <?php echo number_format($enrollment->progress_pct, 1); ?>%
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="label label-<?php echo $enrollment->status == 'active' ? 'success' : 'default'; ?>">
                                        <?php echo ucfirst($enrollment->status); ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo site_url('lms/course/' . $enrollment->slug); ?>" class="btn btn-sm btn-primary">
                                        View Course
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p>You have no enrollments yet. <a href="<?php echo site_url('lms'); ?>">Browse courses</a> to get started.</p>
        <?php endif; ?>
    </div>
</div>