<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel panel-default">
    <div class="panel-body">
        <h3>My Orders</h3>
        
        <?php if (!empty($orders)): ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Order ID</th>
                            <th>Course</th>
                            <th>Amount</th>
                            <th>Payment Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($orders as $order): ?>
                            <tr>
                                <td>#<?php echo $order->id; ?></td>
                                <td><?php echo html_escape($order->title); ?></td>
                                <td>$<?php echo number_format($order->amount, 2); ?></td>
                                <td>
                                    <span class="label label-<?php echo $order->payment_status == 'paid' ? 'success' : 'warning'; ?>">
                                        <?php echo ucfirst($order->payment_status); ?>
                                    </span>
                                </td>
                                <td><?php echo date('M j, Y', strtotime($order->created_at)); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p>No orders found.</p>
        <?php endif; ?>
    </div>
</div>