<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel panel-default">
    <div class="panel-body">
        <h3>My Wishlist</h3>
        
        <?php if (!empty($wishlist_courses)): ?>
            <div class="row">
                <?php foreach ($wishlist_courses as $course): ?>
                    <div class="col-md-4 col-sm-6">
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <h5><?php echo html_escape($course->title); ?></h5>
                                <p><?php echo character_limiter($course->short_desc, 80); ?></p>
                                <div class="course-price">
                                    <strong>$<?php echo number_format($course->price, 2); ?></strong>
                                </div>
                                <a href="<?php echo site_url('lms/course/' . $course->slug); ?>" class="btn btn-primary btn-sm">View Course</a>
                                <button type="button" class="btn btn-default btn-sm wishlist-remove" data-course-id="<?php echo $course->id; ?>">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p>Your wishlist is empty. <a href="<?php echo site_url('lms'); ?>">Browse courses</a> to add some!</p>
        <?php endif; ?>
    </div>
</div>

<script>
$('.wishlist-remove').click(function() {
    var courseId = $(this).data('course-id');
    $.post('<?php echo site_url('lms/wishlist_toggle'); ?>', {course_id: courseId}, function(response) {
        if (response.status === 'success') {
            location.reload();
        }
    }, 'json');
});
</script>