<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><?php echo $title; ?></h3>
            </div>
            <div class="panel-body">
                <div class="row">
                    <?php foreach ($courses as $course) { ?>
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="lms-course-card">
                                <?php if ($course['thumb']) { ?>
                                    <img src="<?php echo $course['thumb']; ?>" class="course-thumbnail" alt="<?php echo $course['title']; ?>">
                                <?php } else { ?>
                                    <div class="course-thumbnail-placeholder">
                                        <i class="fa fa-book"></i>
                                    </div>
                                <?php } ?>
                                <div class="course-content">
                                    <h4><?php echo $course['title']; ?></h4>
                                    <p><?php echo character_limiter($course['short_desc'], 100); ?></p>
                                    <div class="course-price">
                                        <?php echo app_format_money($course['price'], get_base_currency()); ?>
                                    </div>
                                    <div class="course-actions">
                                        <a href="<?php echo site_url('lms/course/' . $course['slug']); ?>" class="btn btn-primary btn-sm">
                                            <?php echo _l('view_details'); ?>
                                        </a>
                                        <button type="button" class="btn btn-outline-secondary btn-sm wishlist-btn" data-course-id="<?php echo $course['id']; ?>">
                                            <i class="fa <?php echo in_array($course['id'], $wishlist) ? 'fa-heart' : 'fa-heart-o'; ?>"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('.wishlist-btn').on('click', function() {
        var btn = $(this);
        var courseId = btn.data('course-id');
        
        $.post('<?php echo site_url('lms/wishlist_toggle'); ?>', {
            course_id: courseId
        }, function(response) {
            if (response.success) {
                var icon = btn.find('i');
                if (response.action === 'added') {
                    icon.removeClass('fa-heart-o').addClass('fa-heart');
                } else {
                    icon.removeClass('fa-heart').addClass('fa-heart-o');
                }
                alert_float('success', response.message);
            }
        }, 'json');
    });
});
</script>