<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel panel-default">
    <div class="panel-body">
        <h3>Checkout</h3>
        
        <?php if (isset($course) && $course): ?>
            <div class="row">
                <div class="col-md-8">
                    <h4>Course Details</h4>
                    <div class="media">
                        <div class="media-body">
                            <h5 class="media-heading"><?php echo html_escape($course->title); ?></h5>
                            <p><?php echo character_limiter($course->short_desc, 200); ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="panel panel-info">
                        <div class="panel-body">
                            <h4>Order Summary</h4>
                            <hr>
                            <div class="row">
                                <div class="col-xs-6">Course Price:</div>
                                <div class="col-xs-6 text-right">$<?php echo number_format($course->price, 2); ?></div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-xs-6"><strong>Total:</strong></div>
                                <div class="col-xs-6 text-right"><strong>$<?php echo number_format($course->price, 2); ?></strong></div>
                            </div>
                            
                            <hr>
                            
                            <?php echo form_open('lms/checkout'); ?>
                                <input type="hidden" name="course_id" value="<?php echo $course->id; ?>">
                                <button type="submit" class="btn btn-success btn-lg btn-block">
                                    <i class="fa fa-credit-card"></i> Complete Purchase
                                </button>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <p>Course not found.</p>
        <?php endif; ?>
    </div>
</div>