<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="row">
    <div class="col-md-8">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><?php echo $course['title']; ?></h3>
            </div>
            <div class="panel-body">
                <?php if ($course['thumb']) { ?>
                    <img src="<?php echo $course['thumb']; ?>" class="img-responsive course-detail-thumbnail" alt="<?php echo $course['title']; ?>">
                <?php } ?>
                
                <div class="course-description">
                    <?php echo nl2br($course['short_desc']); ?>
                </div>
                
                <h4><?php echo _l('lms_course_content'); ?></h4>
                <div class="lectures-list">
                    <?php foreach ($lectures as $index => $lecture) { ?>
                        <div class="lecture-item">
                            <i class="fa fa-play-circle"></i>
                            <span><?php echo ($index + 1) . '. ' . $lecture['title']; ?></span>
                            <?php if ($lecture['duration_sec']) { ?>
                                <span class="lecture-duration"><?php echo lms_lite_format_duration($lecture['duration_sec']); ?></span>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="panel panel-default">
            <div class="panel-body text-center">
                <div class="course-price-large">
                    <?php echo app_format_money($course['price'], get_base_currency()); ?>
                </div>
                
                <?php if ($is_enrolled) { ?>
                    <a href="<?php echo site_url('lms/player/' . $course['slug']); ?>" class="btn btn-success btn-block">
                        <i class="fa fa-play"></i> <?php echo _l('lms_start_learning'); ?>
                    </a>
                    <span class="label label-success"><?php echo _l('enrolled'); ?></span>
                <?php } else { ?>
                    <?php if (is_client_logged_in()) { ?>
                        <a href="<?php echo site_url('lms/enroll/' . $course['id']); ?>" class="btn btn-primary btn-block">
                            <?php echo _l('lms_enroll_now'); ?>
                        </a>
                    <?php } else { ?>
                        <a href="<?php echo site_url('authentication/login'); ?>" class="btn btn-primary btn-block">
                            <?php echo _l('login'); ?>
                        </a>
                    <?php } ?>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
