<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="row">
    <div class="col-md-8">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><?php echo $current_lecture['title']; ?></h3>
            </div>
            <div class="panel-body">
                <?php if ($current_lecture['vimeo_url']) { ?>
                    <div class="video-container">
                        <iframe src="<?php echo $current_lecture['vimeo_url']; ?>" 
                                frameborder="0" 
                                allowfullscreen 
                                class="lecture-video"></iframe>
                    </div>
                <?php } ?>
                
                <div class="lecture-navigation">
                    <?php if ($prev_lecture) { ?>
                        <a href="<?php echo site_url('lms/player/' . $course['slug'] . '/' . $prev_lecture['id']); ?>" 
                           class="btn btn-default">
                            <i class="fa fa-chevron-left"></i> <?php echo _l('lms_previous_lecture'); ?>
                        </a>
                    <?php } ?>
                    
                    <?php if ($next_lecture) { ?>
                        <a href="<?php echo site_url('lms/player/' . $course['slug'] . '/' . $next_lecture['id']); ?>" 
                           class="btn btn-primary pull-right">
                            <?php echo _l('lms_next_lecture'); ?> <i class="fa fa-chevron-right"></i>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h4 class="panel-title"><?php echo $course['title']; ?></h4>
            </div>
            <div class="panel-body">
                <div class="lectures-sidebar">
                    <?php foreach ($lectures as $index => $lecture) { ?>
                        <a href="<?php echo site_url('lms/player/' . $course['slug'] . '/' . $lecture['id']); ?>" 
                           class="lecture-sidebar-item <?php echo $lecture['id'] == $current_lecture['id'] ? 'active' : ''; ?>">
                            <span class="lecture-number"><?php echo $index + 1; ?></span>
                            <span class="lecture-title"><?php echo $lecture['title']; ?></span>
                            <?php if ($lecture['duration_sec']) { ?>
                                <span class="lecture-duration"><?php echo lms_lite_format_duration($lecture['duration_sec']); ?></span>
                            <?php } ?>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>