const emailDialogContent = `
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title" id="exampleModalLabel">Bulk Email <span><button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button></span></h3>
      </div>
      <div class="modal-body">
      <div style="margin-bottom:20px;" class="mt-5"><h4 class="fs-5">Email will be sent for the selected invoices.</h4></div>
      <div class="dropdown">
      <button class="btn btn-lg btn-secondary dropdown-toggle" type="button" id="dynamicDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            Select the template<i class="fa-solid fa-angle-down pull-right"></i>
        </button>
        <ul class="dropdown-menu">
            <li><a class="dropdown-item" data-value="invoice_send_to_customer" href="#">Send Invoice to Customer</a></li>
            <li><a class="dropdown-item" data-value="invoice_expiration_reminder" href="#">Invoice Expiration Reminder</a></li>
        </ul>
       </div>
       <div id="previewTemp"></div>
      </div>
      <div class="modal-footer">
      <button class="btn btn-lg btn-secondary" data-dismiss="modal">Close</button>
      <button class="btn btn-lg btn-primary" id="sendEmailBtn"><div style="
      display: flex;"><div class="send-spinner-email-bulk hidden"></div><span style="
      margin: 5px;">Send Email</span></button>
      </div>
    </div>
  </div>
</div>`;

const waDialogContent = `
<div class="modal fade" id="waModal" tabindex="-1" role="dialog" aria-labelledby="waModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title" id="waModalLabel">Bulk WhatsApp <span><button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button></span></h3>
      </div>
      <div class="modal-body">
      <div style="margin-bottom:20px;" class="mt-5"><h5 class="fs-5">WhatsApp Messages will be sent for the selected invoices.</h5></div>
      <div class="dropdown">
      <button class="btn btn-lg btn-secondary dropdown-toggle" type="button" id="waDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            Select the template<i class="fa-solid fa-angle-down pull-right"></i>
        </button>
        <ul class="dropdown-menu">
            <li><a class="dropdown-item" data-value="invoice_send_to_client" href="#">Send Invoice to Customer</a></li>
            <li><a class="dropdown-item" data-value="invoice_due_notice" href="#">Invoice Expiration Reminder</a></li>
        </ul>
       </div>
       <div id="waPreviewTemp"></div>
      </div>
      <div class="modal-footer">
      <button class="btn btn-lg btn-secondary" data-dismiss="modal">Close</button>
      <button class="btn btn-lg btn-primary" id="sendWaBtn"><div style="
      display: flex;"><div class="send-spinner-wa-bulk hidden"></div><span style="
      margin: 5px;">Send WhatsApp</span></button>
      </div>
    </div>
  </div>
</div>`;


const waInvoiceToCust = "<span>Dear {contact_firstname} {contact_lastname}</span><br><br><span>We have prepared the following invoice for you: # {invoice_number}</span><br><br><span >Invoice status: {invoice_status}</span><br><br><span>You can view the invoice on the following link: {invoice_number}</span><br><br><span>Please contact us for more information.</span>";
const waExpiryReminder = "<span>Hi {contact_firstname} {contact_lastname}<br><br></span>You invoice <span># {invoice_number} will be due on {invoice_duedate}</span><br><br><span>You can view the invoice on the following link: {invoice_number}</span>";



const dialogIntervalId = setInterval(function () {
    if ($('#sendEmailBtn').length > 0) {
        clearInterval(dialogIntervalId);
        addDialogListeners();
    }
}, 50);

let invoiceMap = {
    "invoice-send-to-client": "invoice_send_to_customer",
    "invoice-due-notice": "invoice_due_notice"
}

let templateMessageMap = new Map();


const intervalId = setInterval(function () {
    var $ = jQuery;
    if ($ !== undefined) {
        clearInterval(intervalId);
        $('body').append(emailDialogContent);
        $('body').append(waDialogContent);
        getEmailTemplates();
        createButtons();
    }
}, 10);


// setTimeout(() => {
//     createButtons();
// }, 5000);

function createButtons() {
    addExtraColumns();

    var toggleButton = $('.toggle-small-view');
    var emailIcon = $('<i>').addClass('fa-regular fa-envelope');
    var smsIcon = $('<i>').addClass('fa-solid fa-comment-sms');
    var waIcon = $('<i>').addClass('fa-brands fa-whatsapp');

    var emailButton = $('<button>').html(emailIcon).append(' Send Email');
    var smsButton = $('<button>').html(smsIcon).append(' Send SMS');
    var waButton = $('<button>').html(waIcon).append(' Send WhatsApp');

    emailButton.addClass('btn btn-default mssg-btn');
    smsButton.addClass('btn btn-default mssg-btn');
    waButton.addClass('btn btn-default mssg-btn');

    emailButton.attr('id', 'bulk-email');
    emailButton.attr('type', 'button');
    emailButton.attr('data-toggle', 'modal');
    emailButton.attr('data-target', '#exampleModal');


    smsButton.attr('id', 'bulk-sms');

    waButton.attr('id', 'bulk-wa');
    waButton.attr('type', 'button');
    waButton.attr('data-toggle', 'modal');
    waButton.attr('data-target', '#waModal');
    toggleButton.before(emailButton, smsButton, waButton);

    $('.toggle-small-view').on('click', function () {

        addExtraHeaders();
    });

    $('#small-table').on('click', function () {
        addExtraHeaders();
    });

    function DynamicTableForRow() {
        var $table = $('.table-invoices');
        // Fetch all span elements with the same class name as a NodeList
        const idARowNodeList = document.querySelectorAll('.idARow');
        const hashARowNodeList = document.querySelectorAll('.hashARow');
        const wtspNumRowNodeList = document.querySelectorAll('.wtspNumRow');
        var HideShowWtsp = document.getElementById('HideShowWtsp').textContent;
        console.log(HideShowWtsp);

        // Convert NodeList to an array using Array.from
        const idARowArray = Array.from(idARowNodeList);
        const hashARowArray = Array.from(hashARowNodeList);
        const wtspNumRowArray = Array.from(wtspNumRowNodeList); 
        let indexSpan = 0;

        $table.find('tbody tr').each(function () {
            
            if ($(this).find('.dataTables_empty').length === 0 && $(this).find('.email-checkbox').length === 0 && $(this).find('.sms-checkbox').length === 0 && $(this).find('.wa-checkbox').length === 0) {
                // $(this).append('<td><input class="email-checkbox" type="checkbox"></td><td><input class="sms-checkbox" type="checkbox"></td><td><input class="wa-checkbox" type="checkbox"></td>');  
                if (HideShowWtsp == 0) {
                    $(this).append(
                        '<td><input class="email-checkbox" type="checkbox"></td>' +
                        '<td><input class="sms-checkbox" type="checkbox"></td>' +
                        '<td>' +
                        '<img src="https://' + window.location.hostname + '/assets/images/wicon.jpg" style="width:20px;height:20px;cursor:pointer;filter: grayscale(100%);">' +
                        '</td>'
                        +'<td><input class="wa-checkbox" type="checkbox"></td>'
                    );
                } else {
                    $(this).append(
                        '<td><input class="email-checkbox" type="checkbox"></td>' +
                        '<td><input class="sms-checkbox" type="checkbox"></td>' +
                        '<td><a href="https://' + window.location.hostname + '/invoice/pdfConverter/' +
                        idARowArray[indexSpan].textContent + '/' + hashARowArray[indexSpan].textContent + '/' + wtspNumRowArray[indexSpan].textContent +
                        '" target="_blank">' +
                        '<img src="https://' + window.location.hostname + '/assets/images/wicon.jpg" style="width:20px;height:20px;cursor:pointer;"></a></td>' +
                        '<td><input class="wa-checkbox" type="checkbox"></td>'
                    );
                }
                
                indexSpan++
                
            }
        });
    }
    var reloadBtnInterval = setInterval(function () {
        var length = $('.btn-dt-reload').length;
        if (length > 0) {
            clearInterval(reloadBtnInterval);
            $('.btn-dt-reload').on('click', function () {
                console.log('reload');

                var tgtInterval = setInterval(function () {
                    var tgtElement = $('#DataTables_Table_0_processing');
                    if (tgtElement.length > 0) {
                        clearInterval(tgtInterval);
                        var processInterval = setInterval(function () {
                            var display = document.getElementById('DataTables_Table_0_processing').style.display;
                            if (display === 'none') {
                                clearInterval(processInterval);
                                console.log('none');

                                DynamicTableForRow();
                            }
                        }, 10);
                    }
                }, 10);
            });
        }
    }, 50);





    var searchIntervalId = setInterval(function () {
        var length = $('[type="search"].input-sm').length;
        if (length > 0) {
            clearInterval(searchIntervalId);
            var targetElement = document.getElementById('DataTables_Table_0_processing');

            var observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    if (mutation.attributeName === 'style') {
                        var newDisplayStyle = targetElement.style.display;
                        console.log(newDisplayStyle);
                        if (newDisplayStyle === 'none') {

                            DynamicTableForRow();


                        }
                    }
                });
            });

            var config = { attributes: true, subtree: true };


            $('[type="search"].input-sm').on('change', () => {
                observer.disconnect();
            });

            $('[type="search"].input-sm').on('input', () => {
                observer.observe(targetElement, config);
            });


        }
    }, 50);


    var selectIntervalId = setInterval(function () {
        var length = $('select[name="DataTables_Table_0_length"]').length;
        if (length > 0) {
            clearInterval(selectIntervalId);

            var targetSelect = $('select[name="DataTables_Table_0_length"]');

            var targetElement = document.getElementById('DataTables_Table_0_processing');

            var observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    if (mutation.attributeName === 'style') {
                        var newDisplayStyle = targetElement.style.display;
                        console.log(newDisplayStyle);
                        if (newDisplayStyle === 'none') {

                            DynamicTableForRow();


                        }
                    }
                });
            });
            var config = { attributes: true, subtree: true };
            observer.observe(targetElement, config);

            
            // targetSelect.on('input', function () {
            // });


            // targetSelect.on('change', function () {
            //     var selectedValue = $(this).val();
            //     console.log('Select value changed to:', selectedValue);
            //     // observer.disconnect();
            // });


        }
    }, 50);

     


}

function addExtraHeaders() {
    var tableInterval = setInterval(function () {
        var $table = $('.table-invoices');
        if ($table !== undefined) {
            clearInterval(tableInterval);


            var tbodyInterval = setInterval(function () {
                var length = $table.find('tbody tr').length;
                if (length > 0) {
                    clearInterval(tbodyInterval);

                    const emailCol = $('.email-selectall');
                    const smsCol = $('.sms-selectall');
                    const waCol = $('.wa-selectall');

                    if (emailCol.length === 0 && smsCol.length === 0 && waCol.length === 0) {

                        $table.find('thead tr').append('<th>Email <input style="margin-left:5px" class="email-selectall" type="checkbox"></th><th>SMS <input style="margin-left:5px" class="sms-selectall" type="checkbox"></th><th>WhatsApp <input style="margin-left:5px" class="wa-selectall" type="checkbox"></th>');

                        $('.email-selectall').on('change', function () {
                            if ($(this).is(':checked')) {
                                $('.email-checkbox').prop('checked', true);
                            } else {
                                $('.email-checkbox').prop('checked', false);
                            }
                        });

                        $('.sms-selectall').on('change', function () {
                            if ($(this).is(':checked')) {
                                $('.sms-checkbox').prop('checked', true);
                            } else {
                                $('.sms-checkbox').prop('checked', false);
                            }
                        });

                        $('.wa-selectall').on('change', function () {
                            if ($(this).is(':checked')) {
                                $('.wa-checkbox').prop('checked', true);
                            } else {
                                $('.wa-checkbox').prop('checked', false);
                            }
                        });

                        $('input[type=checkbox]').on('change', function () {
                            if ($(this).is(':checked')) {
                                $(this).prop('checked', true);
                            } else {
                                $(this).prop('checked', false);
                            }
                        });

                    }
                }
            }, 50);

        }
    }, 50);
}

function addExtraColumns() {
    var tableInterval = setInterval(function () {
        var $table = $('.table-invoices');
        if ($table !== undefined) {
            clearInterval(tableInterval);


            var tbodyInterval = setInterval(function () {
                var length = $table.find('tbody tr').length;
                if (length > 0) {
                    clearInterval(tbodyInterval);
                    $table.find('thead tr').append('<th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="Email activate to sort column ascending">Email <input style="margin-left:5px" class="email-selectall" type="checkbox"></th><th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="SMS activate to sort column ascending">SMS <input style="margin-left:5px" class="sms-selectall" type="checkbox"></th>'
                        + '<th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="WhatsApp activate to sort column ascending">Web WhatsApp</th>'

                        + '<th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="WhatsApp activate to sort column ascending"> WhatsApp <input style="margin-left:5px" class="wa-selectall" type="checkbox"></th>'

                    );
                    // Fetch all span elements with the same class name as a NodeList
                    const idARowNodeList = document.querySelectorAll('.idARow');
                    const hashARowNodeList = document.querySelectorAll('.hashARow');
                    const wtspNumRowNodeList = document.querySelectorAll('.wtspNumRow');
                    var HideShowWtsp = document.getElementById('HideShowWtsp').textContent;
                    console.log(HideShowWtsp);

                    // Convert NodeList to an array using Array.from
                    const idARowArray = Array.from(idARowNodeList);
                    const hashARowArray = Array.from(hashARowNodeList);
                    const wtspNumRowArray = Array.from(wtspNumRowNodeList);
             
                    let indexSpan = 0;
                    $table.find('tbody tr').each(function () {
                        if ($(this).find('.email-checkbox').length === 0 && $(this).find('.sms-checkbox').length === 0 && $(this).find('.wa-checkbox').length === 0) {
                            if (HideShowWtsp == 0) {
                                $(this).append(
                                    '<td><input class="email-checkbox" type="checkbox"></td>' +
                                    '<td><input class="sms-checkbox" type="checkbox"></td>' +
                                    '<td>' +
                                    '<img src="https://' + window.location.hostname + '/assets/images/wicon.jpg" style="width:20px;height:20px;cursor:pointer;filter: grayscale(100%);">' +
                                    '</td>'
                                );
                            } else {
                                $(this).append(
                                    '<td><input class="email-checkbox" type="checkbox"></td>' +
                                    '<td><input class="sms-checkbox" type="checkbox"></td>' +
                                    '<td><a href="https://' + window.location.hostname + '/invoice/pdfConverter/' +
                                    idARowArray[indexSpan].textContent + '/' + hashARowArray[indexSpan].textContent + '/' + wtspNumRowArray[indexSpan].textContent +
                                    '" target="_blank">' +
                                    '<img src="https://' + window.location.hostname + '/assets/images/wicon.jpg" style="width:20px;height:20px;cursor:pointer;"></a></td>' +
                                    '<td><input class="wa-checkbox" type="checkbox"></td>'
                                );
                            }

                            indexSpan++
                        }
                    });


                    $('input[type=checkbox]').on('change', function () {
                        if ($(this).is(':checked')) {
                            $(this).prop('checked', true);
                        } else {
                            $(this).prop('checked', false);
                        }
                    });

                    $('.email-selectall').on('change', function () {
                        if ($(this).is(':checked')) {
                            $('.email-checkbox').prop('checked', true);
                        } else {
                            $('.email-checkbox').prop('checked', false);
                        }
                    });

                    $('.sms-selectall').on('change', function () {
                        if ($(this).is(':checked')) {
                            $('.sms-checkbox').prop('checked', true);
                        } else {
                            $('.sms-checkbox').prop('checked', false);
                        }
                    });

                    $('.wa-selectall').on('change', function () {
                        if ($(this).is(':checked')) {
                            $('.wa-checkbox').prop('checked', true);
                        } else {
                            $('.wa-checkbox').prop('checked', false);
                        }
                    });
                }
            }, 50);

        }
    }, 50);
}


function getEmailTemplates() {
    var json;

    $.ajax({
        type: 'get',
        url: admin_url + 'messaging',
        success: function (response) {
            json = JSON.parse(response);
            console.log(json);
            console.log(json["invoice"]);
            $.each(json["invoice"], function (index, $invoice) {
                if (invoiceMap[$invoice["slug"]] !== undefined) {
                    templateMessageMap[invoiceMap[$invoice["slug"]]] = $invoice["message"];
                }
            });
        },
        error: function (response) {
            console.log('Some Error happened while getting Email Templates');
        }
    });

    return json;
}


function addDialogListeners() {


    $('#bulk-email').on('click', function () {
        $('#exampleModal').remove();

        setTimeout(function () {
            $('body').append(emailDialogContent);
            $('#exampleModal').modal('show');

            $('.dropdown-item').on('click', function () {
                $('#previewTemp').empty();
                var selectedText = $(this).text();
                var selectedValue = $(this).data('value');
                $('#dynamicDropdown').html(selectedText + '<i class="fa-solid fa-angle-down pull-right"></i>');
                $('#dynamicDropdown').attr('data-value', selectedValue);

                const pdfCheckbox = `<div class="checkbox checkbox-primary" id="pdf-div">
                <input type="checkbox" name="attach_pdf_bulk" id="attach_pdf_bulk" checked>
                <label for="attach_pdf_bulk">Attach PDF</label>
                </div>`;

                let ccInput = '';

                $.ajax({
                    type: 'POST',
                    url: admin_url + 'messaging/render_input',
                    data: {
                        name: 'ccAddress',
                        label: 'CC'
                    },
                    success: function (response) {

                        ccInput = response;

                        $.ajax({
                            type: 'POST',
                            url: admin_url + 'messaging/render_textarea',
                            data: {
                                template_message: templateMessageMap[selectedValue],
                                name: 'email_template_bulk_custom'
                            },
                            success: function (textarea) {
                                $('#email_template_bulk_custom').remove();
                                $('#pdf-div').remove();
                                $('[app-field-wrapper="ccAddress"]').remove();
                                var previewMssg = `<h5 class="bold">Preview Template</h5><hr>`;
                                var items = [pdfCheckbox, ccInput, previewMssg, textarea];
                                if (selectedValue === 'invoice_due_date') {
                                    $('#previewTemp').append(previewMssg, textarea);
                                } else {
                                    $('#previewTemp').append(items);
                                }

                                const textareaInterval = setInterval(function () {
                                    const textarea = $('#email_template_bulk_custom');
                                    if (textarea.length > 0) {
                                        console.log('yes');
                                        clearInterval(textareaInterval);
                                        tinymce.remove('#email_template_bulk_custom');
                                        tinymce.init({
                                            selector: '#email_template_bulk_custom',
                                            plugins: 'autolink lists link image charmap print preview anchor',
                                            toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image'
                                        });
                                    } else {
                                        console.log('no');
                                    }
                                }, 10);
                            },
                            error: function (response) {
                                console.log('Some Error occured while sending email');
                            }
                        });
                    },
                    error: function (response) {
                        console.log('Some Error occured while sending email');
                    }
                });




            });


            $('#sendEmailBtn').on('click', function () {
                $('.send-spinner-email-bulk').removeClass('hidden');
                $('#sendEmailBtn').addClass('disabled');
                var invoice_ids = []
                $('.email-checkbox').each(function (index, checkbox) {
                    if (checkbox.checked) {
                        var href = $(this).parent().parent().find('td a')[0].href;
                        var id = href.substring(href.lastIndexOf("/") + 1);
                        invoice_ids.push(id);
                    }
                })


                var template_path = $('#dynamicDropdown').attr('data-value');
                if (template_path !== '' && template_path !== undefined) {
                    var cc = $('#ccAddress').val()
                    var attach_pdf = $('#attach_pdf_bulk').prop('checked');
                    if (attach_pdf === false) {
                        attach_pdf = '';
                    }
                    var iframe = $('#email_template_bulk_custom_ifr')[0].contentWindow
                    var email_template_custom = $($(iframe.document).find('#tinymce p')[0]).html();
                    email_template_custom = email_template_custom.replace('%7B', '{');
                    email_template_custom = email_template_custom.replace('%7D', '}');
                    console.log(email_template_custom);
                    $.ajax({
                        type: 'POST',
                        url: admin_url + 'messaging/send_email',
                        data: {
                            ids: invoice_ids,
                            cc: cc,
                            attach_pdf: attach_pdf,
                            email_template_custom: email_template_custom,
                            template_name: (template_path == 'invoice_send_to_customer' ? 'invoice-send-to-client' : 'invoice-due-notice')
                        },
                        success: function (response) {
                            $('.send-spinner-email-bulk').addClass('hidden');
                            $('#sendEmailBtn').removeClass('disabled');
                            location.reload();
                            console.log(response);
                        },
                        error: function (response) {
                            console.log('Some Error occured while sending email');
                        }
                    });
                }

            });


        }, 300)

    });

    $('#bulk-wa').on('click', function () {

        $('#waModal').remove();

        setTimeout(function () {
            $('body').append(waDialogContent);
            $('#waModal').modal('show');


            $('.dropdown-item').on('click', function () {
                $('#waPreviewTemp').empty();
                var selectedText = $(this).text();
                var selectedValue = $(this).data('value');
                $('#waDropdown').html(selectedText + '<i class="fa-solid fa-angle-down pull-right"></i>');
                $('#waDropdown').attr('data-value', selectedValue);


                $.ajax({
                    type: 'POST',
                    url: admin_url + 'messaging/render_textarea',
                    data: {
                        template_message: (selectedValue === 'invoice_send_to_customer') ? waInvoiceToCust : waExpiryReminder,
                        name: 'wa_template_bulk_custom'
                    },
                    success: function (textarea) {
                        console.log(textarea);
                        var previewMssg = `<h5 class="bold">Preview Template</h5><hr>`;
                        $('#wa_template_bulk_custom').remove();
                        $('#waPreviewTemp').append(previewMssg, textarea);

                        const textareaInterval = setInterval(function () {
                            const textarea = $('#wa_template_bulk_custom');
                            if (textarea.length > 0) {
                                clearInterval(textareaInterval);
                                console.log('inside textar');
                                tinymce.remove('#wa_template_bulk_custom');
                                tinymce.init({
                                    selector: '#wa_template_bulk_custom',
                                    plugins: 'autolink lists link image charmap print preview anchor',
                                    toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image'
                                });
                            }
                        }, 10);
                    },
                    error: function (response) {
                        console.log('Some Error occured while sending email');
                    }
                });




            });


            $('#sendWaBtn').on('click', function () {
                $('.send-spinner-wa-bulk').removeClass('hidden');
                $('#sendWaBtn').addClass('disabled');
                var invoice_ids = []
                $('.wa-checkbox').each(function (index, checkbox) {
                    if (checkbox.checked) {
                        var href = $(this).parent().parent().find('td a')[0].href;
                        var id = href.substring(href.lastIndexOf("/") + 1);
                        invoice_ids.push(id);
                    }
                })

                var value = $('[name="_attachment_sale_id"]').val();

                if (invoice_ids.length)

                    var template_path = $('#waDropdown').attr('data-value');
                var template_text = $('#waDropdown').text();
                if (template_path !== '' && template_path !== undefined) {

                    $.ajax({
                        type: 'POST',
                        url: admin_url + 'messaging/send_to_wa_invoice',
                        data: {
                            ids: invoice_ids,
                            template_name: template_path,
                            template_text: template_text,
                            rel_type: 'invoice'
                        },
                        success: function (response) {
                            // $('#waModal').modal('hide');
                            $('.send-spinner-wa-bulk').addClass('hidden');
                            $('#sendWaBtn').removeClass('disabled');
                            location.reload();
                        },
                        error: function (response) {
                            console.log('Some Error occured while sending email');
                        }
                    });
                }

            });
        }, 300);

    });

}