var sendToWaContent = `
<div class="modal fade" id="sendToWa" tabindex="-1" role="dialog" aria-labelledby="sendToWaLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title" id="sendToWaLabel">Send Proposal to WhatsApp
        <span><button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button></span></h3>
      </div>
      <div class="modal-body">
        <h5 class="bold">Preview Template</h5><hr>
        <div id="waPreview"></div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-lg btn-secondary" data-dismiss="modal">Close</button>
        <button class="btn btn-lg btn-primary" id="sendWa"><div style="
        display: flex;"><div class="send-spinner-wa hidden"></div><span style="
        margin: 5px;">Send WhatsApp</span></div></button>
      </div>
    </div>
  </div>
</div>`;

const intValId = setInterval(function() {
    var $ = jQuery;
    if( $ !== undefined) {
        clearInterval(intValId);
        $('body').append(sendToWaContent);
        setPreviewContent();
        createTabButtons();
    }
},10);

function createTabButtons() {

    tdInterval = setInterval(function() {
        const td = $('.table-proposals td');
        if(td.length > 0) {
            clearInterval(tdInterval);
            addWhatsAppIcon();
            console.log('yes');
            $(document).on('click', '.table-proposals td:nth-child(1)', function() {
                addWhatsAppIcon();
            });

            $(document).on('click', '.table-proposals td:nth-child(2)', function() {
                addWhatsAppIcon();
            });

        }
    }, 50);
}


function addWhatsAppIcon() {
    console.log('whatsapp');
    var li = `<li role="presentation" data-toggle="tooltip" title="WhatsApp Tracking" class="tab-separator"><a href="#tab_wa_tracking" aria-controls="tab_wa_tracking" role="tab" data-toggle="tab"><i class="fa-lg fa-brands fa-whatsapp" aria-hidden="true"></i></a></li>`;
    var wa = $(li);
    var liInterval = setInterval(function() {
        const li = $('.nav-tabs-horizontal li');
        const email_icon = $('[data-target="#proposal_send_to_customer"]');
        if(li.length > 0 && email_icon.length > 0) {
            clearInterval(liInterval);
            setTimeout(function() {
                if($('#send_wa').length == 0) {
                    addWaModal();
                }
            }, 1000);
            
            setTimeout(function() {
                if($('[href="#tab_wa_tracking"]').length == 0) {
                    $('.nav-tabs-horizontal li:nth-last-child(3)').after(wa);
                    getWhatsAppStatusOnCLick();
                }
    
                if($('#tab_wa_tracking').length == 0) {
                    addWaTabContent();
                }

            }, 1000);
        }
    }, 50);
}

function addWaTabContent() {
    var waDiv = `<div role="tabpanel" class="tab-pane ptop10 flex justify-center items-center h-screen" id="tab_wa_tracking">
    <h4 class="tw-m-0 tw-text-lg tw-font-medium tw-text-neutral-600">Tracked WhatsApp Messages Sent</h4>
    <div id="spinnerContainer" style="display: flex; justify-content: center; margin: 25px;"><div class="spinner-border"></div></div>
    <div id="tracked-wa-table" class="table-responsive"></div>
    </div>`;
    $('.tab-content').append(waDiv);


}


function constructTable(json) {

    var table = $('<table>').addClass('table ');
    $('#tracked-wa-table').append(table);
  
    // Create thead and append it to the table
    var thead = $('<thead>').append(
      $('<tr>').append(
        $('<th>').html('<b>Date</b>'),
        $('<th>').html('<b>Template</b>'),
        $('<th>').html('<b>To</b>'),
        $('<th>').html('<b>Status</b>')
      )
    );
    table.append(thead);
  
    // Create tbody and append it to the table
    var tbody = $('<tbody>');
  
    // Create data rows and append them to the tbody
    json.forEach(function(data) {
        var dataRow = $('<tr>').append(
            $('<td>').text(data['date']),
            $('<td>').text(data['template_name']),
            $('<td>').text(data['to']),
            $('<td>').text(data['status'])
        );
        tbody.append(dataRow);
    });
  
    // Append the tbody to the table
    table.append(tbody);
}

function getWhatsAppStatusOnCLick() {
    var waInterval = setInterval(function() {
        var waIcon = $('[href="#tab_wa_tracking"]');
        if(waIcon.length > 0) {
            clearInterval(waInterval);

            $('[href="#tab_wa_tracking"]').on('click', function() {
                $('#tracked-wa-table').empty();
                $("#spinnerContainer").removeClass("hidden");
                var idString = $('[name="_attachment_sale_id"]').val();
                var id = Number(idString);
                console.log(id);
                $.ajax({
                    type: 'POST',
                    url: admin_url + 'messaging/get_wa_status',
                    data: {
                        id: id,
                        rel_type: 'proposal'
                    },
                    success: function(response) {
                        hideProgressBar();
                        var json = JSON.parse(response);
                        var waSelectorInterval = setInterval(function() {
                            var waTable = $('#tracked-wa-table');
                            if(waTable.length > 0) {
                                clearInterval(waSelectorInterval);
                                constructTable(json);
                            }
                        }, 50);
                    },
                    error: function(response) {
                        console.log('Some Error occured while sending email');
                    }
                });

            })

        }
    }, 50);
}


function addWaModal() {
    var waAnchorTagString = `
    <a href="#" id="send_wa" class="btn btn-default btn-with-tooltip" data-target="#sendToWa" data-toggle="modal" style="
    margin-left: 4px;"><span data-toggle="tooltip" class="btn-with-tooltip" data-title="Send to WhatsApp" data-placement="bottom"><i class="fa-lg fa-brands fa-square-whatsapp"></i></span></a>
    `;

    var waIcon = $(waAnchorTagString);
    var send_to_email = $('[data-target="#proposal_send_to_customer"]');
    send_to_email.after(waIcon);


    $('#send_wa').on('click', function() {


        $('#sendWa').on('click', function() {
            $('.send-spinner-wa').removeClass('hidden');
            $('#sendWa').addClass('disabled');
            var proposal_ids = [];
            var value = $('[name="_attachment_sale_id"]').val();
            proposal_ids.push(value);
            $.ajax({
                type: 'POST',
                url: admin_url + 'messaging/send_to_wa',
                data: {
                    ids: proposal_ids,
                    template_name: 'proposal-send-to-customer',
                    template_text: 'Send proposal to Customer',
                    rel_type: 'proposal'
                },
                success: function(response) {
                    $('.send-spinner-wa').addClass('hidden');
                    $('#sendWa').removeClass('disabled');
                    location.reload();
                    console.log(response);
                },
                error: function(response) {
                    console.log('Some Error occured while sending email');
                }
            });

        });

    });
    

}

function setPreviewContent() {
    var textarea = `<div class="form-group" app-field-wrapper="send_proposal_wa_custom"><textarea id="send_proposal_wa_custom" name="send_proposal_wa_custom" class="form-control tinymce-proposal" rows="4">Dear {proposal_proposal_to}, Please find our attached proposal. This proposal is valid until: {proposal_open_till}. You can view the proposal on the following link: {proposal_link}. Please don&#039;t hesitate to comment online if you have any questions. We look forward to your communication.</textarea></div>`;
    $('#send_proposal_wa_custom').remove();
    $('#waPreview').append(textarea);
    
    var textInterval = setInterval(function() {
        var textarea = $('#send_proposal_wa_custom');
        if(textarea.length > 0 && tinymce !== undefined) {
            clearInterval(textInterval);
            console.log('inside textare');
            tinymce.remove('#send_proposal_wa_custom');
            tinymce.init({
                selector: '#send_proposal_wa_custom',
                plugins: 'autolink lists link image charmap print preview anchor',
                toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image'
            });
        } 
    }, 10);
}


function hideProgressBar() {
    $("#spinnerContainer").addClass("hidden");
}