<?php
// Allow CORS requests from any origin
header("Access-Control-Allow-Origin: *");
// Allow specific HTTP methods
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
// Allow specific headers
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    // Respond to preflight request and exit
    exit(0);
}

// Define the directory where you want to save the uploaded files
$uploadDir = 'pdfData/';

// Check if the directory exists, if not, create it
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Check if file was uploaded without errors
    if (isset($_FILES['file']) && $_FILES['file']['error'] == UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['file']['tmp_name'];
        $fileName = $_FILES['file']['name'];
        $fileSize = $_FILES['file']['size'];
        $fileType = $_FILES['file']['type'];
        $fileNameCmps = pathinfo($fileName);
        $fileExtension = strtolower($fileNameCmps['extension']);

        // Allow only PDF files
        $allowedfileExtensions = array('pdf');
        if (in_array($fileExtension, $allowedfileExtensions)) {
            // Create a unique file name to avoid overwriting existing files
            $newFileName = md5(time() . $fileName) . '.' . $fileExtension;

            // Move the file to the designated directory
            $dest_path = '../../../../'. "assets".'/'.$uploadDir . $newFileName;

            if (move_uploaded_file($fileTmpPath, $dest_path)) {
                echo json_encode(['url' =>  "https://". $_SERVER['HTTP_HOST']."/"."assets/".$uploadDir . $newFileName]);
            } else {
                echo json_encode(['error' => 'There was an error moving the uploaded file','url'=>$dest_path]);
            }
        } else {
            echo json_encode(['error' => 'Upload failed. Allowed file types: ' . implode(',', $allowedfileExtensions)]);
        }
    } else {
        echo json_encode(['error' => 'No file uploaded or there was an upload error']);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
