<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
Module Name: client
Description: A simple client module for Perfex CRM
Version: 1.0.0
Author: sa
Requires at least: 2.3.2
*/



// Register activation hook
register_activation_hook('client', 'client_activation_hook');

// Register deactivation hook  
register_deactivation_hook('client', 'client_deactivation_hook');

// Module activation function
function client_activation_hook() {
    // Add any setup code here when module is activated
    log_activity('client Module Activated');
}

// Module deactivation function
function client_deactivation_hook() {
    // Add any cleanup code here when module is deactivated
    log_activity('client Module Deactivated');
}

// Add admin menu item
hooks()->add_action('admin_init', 'client_admin_menu');

function client_admin_menu() {
    $CI = &get_instance();
    
    if (has_permission('client', '', 'view')) {
        $CI->app_menu->add_sidebar_menu_item('client-main', [
            'name'     => 'client',
            'href'     => admin_url('client'),
            'position' => 35,
            'icon'     => 'fa fa-globe',
        ]);



    }
}

// Add permission
hooks()->add_filter('staff_permissions', 'client_permissions');

function client_permissions($permissions) {
    $permissions['client'] = [
        'name' => 'client',
        'capabilities' => [
            'view' => 'View client'
        ]
    ];
    
    return $permissions;
}
?>