<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Client_model extends CI_Model
{
    private $table = 'clients_custom';//table name

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Insert a new client
     * @param array $data
     * @return int|bool Inserted ID or false
     */
    public function insert($data)
    {
        $data['created_at'] = date('Y-m-d H:i:s'); // Add timestamp
        if ($this->db->insert($this->table, $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    /**
     * Get all clients
     * @return array
     */
    public function get_all()
    {
        return $this->db->order_by('id', 'DESC')
                        ->get($this->table)
                        ->result_array();
    }

}
