<?php defined('BASEPATH') or exit('No direct script access allowed');


use Twilio\Rest\Client;

class Messaging extends AdminController{

    protected $sid;

    protected $token;

    protected $mssg_service_id;

    protected $proposal_to_customer_template_id;

    protected $proposal_expiry_reminder_template_id;

    protected $estimate_to_customer_template_id;

    protected $estimate_expiration_reminder_template_id;

    protected $invoice_to_customer_template_id;

    protected $invoice_due_notice_template_id;

    public function __construct() {
        parent::__construct();
        $this->CI =& get_instance();
        $this->load->model('emails_model');
        $this->load->model('proposals_model');
        $this->load->model('estimates_model');
        $this->load->model('invoices_model');
        $this->load->model('clients_model');
        $this->CI->load->config('api');

        $this->sid  = $this->CI->config->item('sid');
        $this->token = $this->CI->config->item('token');
        $this->mssg_service_id  = $this->CI->config->item('mssg_service_id');
        $this->proposal_to_customer_template_id  = $this->CI->config->item('proposal_to_customer_template_id');
        $this->proposal_expiry_reminder_template_id  = $this->CI->config->item('proposal_expiry_reminder_template_id');
        $this->estimate_to_customer_template_id  = $this->CI->config->item('estimate_to_customer_template_id');
        $this->estimate_expiration_reminder_template_id = $this->CI->config->item('estimate_expiration_reminder_template_id');
        $this->invoice_to_customer_template_id  = $this->CI->config->item('invoice_to_customer_template_id');
        $this->invoice_due_notice_template_id = $this->CI->config->item('invoice_due_notice_template_id');
    }

    public function index() {
        $data['credit_notes'] = $this->emails_model->get([

            'type'     => 'credit_note',

            'language' => 'english',

        ]);

        $data['invoice'] = $this->emails_model->get([

            'type'     => 'invoice',

            'language' => 'english',

        ]);

        $data['estimate'] = $this->emails_model->get([

            'type'     => 'estimate',

            'language' => 'english',

        ]);

        $data['proposals'] = $this->emails_model->get([

            'type'     => 'proposals',

            'language' => 'english',

        ]);


        $response = array('message' => $data );
        echo json_encode($data);

    }
    // number formation
    public function formatPhoneNumber($number)
    {
        // Remove any non-numeric characters
        $number = preg_replace('/\D/', '', $number);
        // Check if the number is empty or invalid
        if (empty($number) || !is_numeric($number)) {
            return "Error: Invalid number.";
        }
        // If the number starts with '+91', remove the '+'
        if (substr($number, 0, 3) == '091') {
            $number = substr($number, 1);
        }
        // If the number starts with '91' and is 12 digits long, return it as is
        elseif (substr($number, 0, 2) == '91' && strlen($number) == 12) {
            return $number;
        }
        // If the number starts with '91' and is not 12 digits long, correct it
        elseif (substr($number, 0, 2) == '91') {
            $number = '91' . substr($number, 2);
        }
        // If the number is 10 digits long, add '91' at the beginning
        elseif (strlen($number) == 10) {
            $number = '91' . $number;
        }
        // If the number is already 12 digits long, return it as is
        elseif (strlen($number) == 12) {
            return $number;
        }

        return $number;
    }
    public function formatPhoneNumberFor10Digit($number) {
        // Remove any non-numeric characters
        $number = preg_replace('/\D/', '', $number);
    
        // Check if the number is empty or invalid
        if (empty($number) || !is_numeric($number)) {
            return "Error: Invalid number.";
        }
    
        // If the number starts with '91' and is 12 digits long, remove '91'
        if (substr($number, 0, 2) == '91' && strlen($number) == 12) {
            return substr($number, 2);
        }
        // If the number is 10 digits long, return it as is
        elseif (strlen($number) == 10) {
            return $number;
        }
        // If the number is already 12 digits long and starts with '91', remove '91'
        elseif (strlen($number) == 12 && substr($number, 0, 2) == '91') {
            return substr($number, 2);
        }
        // If the number starts with '0' and is 11 digits long, remove the '0'
        elseif (strlen($number) == 11 && $number[0] == '0') {
            return substr($number, 1);
        }
    
        return "Error: Invalid number format.";
    }
    public function messageUnit($template_name,$to,$variables){
        return $messagePayload = [
            "integrated_number" => "918494966977",
            "content_type" => "template",
            "payload" => [
                "messaging_product" => "whatsapp",
                "type" => "template",
                "template" => [
                    "name" => $template_name,// Template Name
                    "language" => [
                        "code" => "en",
                        "policy" => "deterministic"
                    ],
                    "namespace" => null,
                    "to_and_components" => [
                        [
                            "to" => $to,// phone number 
                            "components" => [ // variable array
                                "body_1" => [
                                    "type" => "text",
                                    "value" => $variables["body_1"] 
                                ],
                                "body_2" => [
                                    "type" => "text",
                                    "value" => $variables["body_2"]
                                ],
                                "body_3" => [
                                    "type" => "text",
                                    "value" => $variables["body_3"]
                                ],
                                "body_4" => [
                                    "type" => "text",
                                    "value" => $variables["body_4"]
                                ],
                                "body_5" => [
                                    "type" => "text",
                                    "value" => $variables["body_5"]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

    }

    private function send_to_email($id)

    {

        $canView = user_can_view_proposal($id);

        if (!$canView) {

            access_denied('proposals');

        } else {

            if (!has_permission('proposals', '', 'view') && !has_permission('proposals', '', 'view_own') && $canView == false) {

                access_denied('proposals');

            }

        }



        if ($this->input->post()) {

            try {

                $success = $this->proposals_model->send_proposal_to_email(

                    $id,

                    $this->input->post('attach_pdf'),

                    $this->input->post('cc')

                );

            } catch (Exception $e) {

                $message = $e->getMessage();

                echo $message;

                if (strpos($message, 'Unable to get the size of the image') !== false) {

                    show_pdf_unable_to_get_image_size_error();

                }

                die;

            }
            

        }

    }



    public function send_expiry_reminder($id)

    {

        $canView = user_can_view_proposal($id);

        if (!$canView) {

            access_denied('proposals');

        } else {

            if (!has_permission('proposals', '', 'view') && !has_permission('proposals', '', 'view_own') && $canView == false) {

                access_denied('proposals');

            }

        }

        $this->proposals_model->send_expiry_reminder($id);

    }

    
    public function send_estimate_to_client($id, $template_name = '', $attachpdf = true, $cc = '', $manually = false)

    {

        $estimate = $this->estimates_model->get($id);



        $estimate_number = format_estimate_number($estimate->id);



        $emails_sent = [];

        $send_to     = [];


        $client_id = $estimate->clientid;
        $contacts = $this->clients_model->get_contacts($client_id);
        foreach ($contacts as $contact) {
            array_push($send_to, $contact["id"]);
        }

        $status_auto_updated = false;

        $status_now          = $estimate->status;



        if (is_array($send_to) && count($send_to) > 0) {

            $i = 0;



            // Auto update status to sent in case when user sends the estimate is with status draft

            if ($status_now == 1) {

                $this->db->where('id', $estimate->id);

                $this->db->update(db_prefix() . 'estimates', [

                    'status' => 2,

                ]);

                $status_auto_updated = true;

            }



            if ($attachpdf) {

                $_pdf_estimate = $this->estimates_model->get($estimate->id);

                set_mailing_constant();

                $pdf = estimate_pdf($_pdf_estimate);



                $attach = $pdf->Output($estimate_number . '.pdf', 'S');

            }



            foreach ($send_to as $contact_id) {

                if ($contact_id != '') {

                    // Send cc only for the first contact

                    if (!empty($cc) && $i > 0) {

                        $cc = '';

                    }



                    $contact = $this->clients_model->get_contact($contact_id);



                    if (!$contact) {

                        continue;

                    }



                    $template = mail_template($template_name, $estimate, $contact, $cc);



                    if ($attachpdf) {

                        $hook = hooks()->apply_filters('send_estimate_to_customer_file_name', [

                            'file_name' => str_replace('/', '-', $estimate_number . '.pdf'),

                            'estimate'  => $_pdf_estimate,

                        ]);



                        $template->add_attachment([

                            'attachment' => $attach,

                            'filename'   => $hook['file_name'],

                            'type'       => 'application/pdf',

                        ]);

                    }



                    if ($template->send()) {

                        array_push($emails_sent, $contact->email);

                    }

                }

                $i++;

            }

        } else {

            return false;

        }



        if (count($emails_sent) > 0) {

            $this->estimates_model->set_estimate_sent($id, $emails_sent);

            hooks()->do_action('estimate_sent', $id);



            return true;

        }



        if ($status_auto_updated) {

            // Estimate not send to customer but the status was previously updated to sent now we need to revert back to draft

            $this->db->where('id', $estimate->id);

            $this->db->update(db_prefix() . 'estimates', [

                'status' => 1,

            ]);

        }



        return false;

    }



    public function send_expiry_reminder_estimate($id)

    {

        $estimate        = $this->estimates_model->get($id);

        $estimate_number = format_estimate_number($estimate->id);

        set_mailing_constant();

        $pdf              = estimate_pdf($estimate);

        $attach           = $pdf->Output($estimate_number . '.pdf', 'S');



        $contacts = $this->clients_model->get_contacts($estimate->clientid, ['active' => 1, 'estimate_emails' => 1]);



        foreach ($contacts as $contact) {

            $template = mail_template('estimate_expiration_reminder', $estimate, $contact);

            $template->add_attachment([

                'attachment' => $attach,

                'filename'   => str_replace('/', '-', $estimate_number . '.pdf'),

                'type'       => 'application/pdf',

            ]);

            $template->send();
        }

    }


    public function send_email() {
        $ids = $_POST['ids'];
        $template_name = $_POST['template_name'];
        foreach ($ids as $id) {
            if($template_name === 'proposal-send-to-customer') {
                $this->send_to_email((int)$id);
            } else if($template_name === 'proposal-expiry-reminder') {
                $this->send_expiry_reminder((int)$id);
            } else if($template_name === 'estimate-send-to-client') {
                $this->send_estimate_to_client((int)$id, 'estimate_send_to_customer', $_POST['attach_pdf'], $_POST['cc']);
            } else if($template_name === 'estimate-expiry-reminder') {
                $this->send_expiry_reminder_estimate((int)$id);
            } else if($template_name === 'invoice-send-to-client') {
                $this->send_invoice_to_client((int)$id, 'invoice_send_to_customer', $_POST['attach_pdf'], $_POST['cc']);
            } else if($template_name === 'invoice-due-date') {

            }
        }
        echo json_encode($ids);
    }

    public function render_textarea()
    {
        $message = $_POST['template_message'];
        $name = $_POST['name'];
        // 'email_template_bulk_custom'
        $textarea = render_textarea($name, '', $message, [], [], '', 'tinymce-proposal');
        echo $textarea;
    }

    public function render_input() {
        $name = $_POST['name'];
        $label = $_POST['label'];
        $input = render_input($name, $label);
        echo $input;
    }

    public function send_to_wa()
    {
        $ids = $_POST['ids'];
        $template_name = $_POST['template_name'];
        $template_text = $_POST['template_text'];
        $rel_type = $_POST['rel_type'];
        // $twilio = new Client($this->sid, $this->token);
    
        foreach ($ids as $id) {
            $proposal = $this->proposals_model->get($id);
    
            $url = site_url('proposal/' . $id . '/' . $proposal->hash);
            $proposal_to = $proposal->proposal_to;
            $open_till = $proposal->open_till;
            $phone = $this->formatPhoneNumber($proposal->phone);
    
            $to = [$phone];
    
            $contentSid = $this->proposal_to_customer_template_id;
            $templateNameForMSG91 = $template_name !== 'proposal_send_to_customer' ? "proposalexpriation" : "proposawainvoice";
    
            $variables = [
                "body_1" => $proposal_to,
                "body_2" => $open_till,
                "body_3" => $url
            ];
    
            if ($template_name === 'proposal_send_to_customer') {
                $contentSid = $this->proposal_expiry_reminder_template_id;
                $variables = [
                    "body_1" => $proposal_to,
                    "body_2" => format_proposal_number($id),
                    "body_3" => $open_till,
                    "body_4" => $url
                ];
            }
    
            // Create components array dynamically
            $components = [];
            foreach ($variables as $key => $value) {
                $components[$key] = [
                    "type" => "text",
                    "value" => $value
                ];
            }
    
            $messagePayload = [
                "integrated_number" => "918494966977",
                "content_type" => "template",
                "payload" => [
                    "messaging_product" => "whatsapp",
                    "type" => "template",
                    "template" => [
                        "name" => $templateNameForMSG91,
                        "language" => [
                            "code" => "en",
                            "policy" => "deterministic"
                        ],
                        "namespace" => null,
                        "to_and_components" => [
                            [
                                "to" => $to,
                                "components" => $components
                            ]
                        ]
                    ]
                ]
            ];
    
            print_r($variables);
    
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://api.msg91.com/api/v5/whatsapp/whatsapp-outbound-message/bulk/',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($messagePayload),
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    'authkey: 419920AGWjI9ahNn4766274beeP1',
                    'Cookie: PHPSESSID=q82npotm8s19dm9cdg1d09f3a2'
                ],
            ]);
    
            $response = curl_exec($ch);
            curl_close($ch);
    
            $response_data = json_decode($response, true);
            $message_id = $response_data['request_id'] ?? '';
    
            $data = [
                "mssg_id" => $message_id,
                "template_name" => $template_text,
                "rel_id" => $id,
                "rel_type" => $rel_type,
                "status" => $response_data['status'] ?? 'failed',
                "to" => json_encode($to)
            ];
    
            add_wa_tracking($data);
        }
    }
    

    public function send_to_wa_twillio() {
        $ids = $_POST['ids'];
        $template_name = $_POST['template_name'];
        $template_text = $_POST['template_text'];
        $rel_type = $_POST['rel_type'];
        $twilio = new Client($this->sid, $this->token);
    
        foreach ($ids as $id) {
            $proposal = $this->proposals_model->get($id);

            $url = site_url('proposal/' . $id . '/' . $proposal->hash);
            $proposal_to = $proposal->proposal_to;
            $open_till = $proposal->open_till;
            $phone = $proposal->phone;
            if (substr($phone, 0, 3) !== '+91') {
                $phone = '+91' . $phone;
            }

            $contentSid = $this->proposal_to_customer_template_id;
            $variables = [
                "1" => $proposal_to,
                "2" => $open_till,
                "3" => $url
            ];
            if($template_name == 'proposal-expiry-reminder') {
                $contentSid = $this->proposal_expiry_reminder_template_id;
                $variables = [
                    "1" => $proposal_to,
                    "2" => format_proposal_number($id),
                    "3" => $open_till,
                    "4" => $url
                ];
            }



            $message = $twilio->messages
            ->create("whatsapp:{$phone}", // to
                        [
                            "contentSid" => $contentSid,
                            "from" => $this->mssg_service_id,
                            "contentVariables" => json_encode($variables)
                        ]
            );
            
            $data = [
                "mssg_id" => $message->sid,
                "template_name" => $template_text,
                "rel_id" => $id,
                "rel_type" => $rel_type,
                "status" => $message->status,
                "to" => $phone
            ];

            add_wa_tracking($data);
        }


    }

    public function get_wa_status() {
        $rel_id = $_POST['id'];
        $rel_type = $_POST['rel_type'];
        $tracked_wa = get_tracked_wa($rel_id, $rel_type);
        $twilio = new Client($this->sid, $this->token);
        foreach($tracked_wa as $wa) {
            $mssg_id = $wa['mssg_id'];
            $message = $twilio->messages($mssg_id)->fetch();
            update_tracked_wa($rel_id, $rel_type, $mssg_id, $message->status);
        }
        $updated_tracked_wa = get_tracked_wa($rel_id, $rel_type);
        echo json_encode($updated_tracked_wa);
    }
    public function send_to_wa_estimate()
    {
        $ids = $_POST['ids'];
        $template_name = $_POST['template_name'];
        $template_text = $_POST['template_text'];
        $rel_type = $_POST['rel_type'];
        
        foreach ($ids as $id) {
            $estimate = $this->estimates_model->get($id);
            $client_id = $estimate->clientid;
            $contacts = $this->clients_model->get_contacts($client_id);

            foreach ($contacts as $contact) {

                $first_name = $contact["firstname"];
                $last_name = $contact["lastname"];
                $estimate_number = format_estimate_number($estimate->id);
                $estimate_status = format_estimate_status($estimate->status, '', false);
                $url = site_url('estimate/' . $id . '/' . $estimate->hash);
                 
                
                $contentSid = $this->estimate_to_customer_template_id;
                $variables = [
                    "body_1" => $first_name,
                    "body_2" => $last_name,
                    "body_3" => $estimate_number,
                    "body_4" => $estimate_status,
                    "body_5" => $url
                ];
                if ($template_name !== 'estimate_send_to_customer') {
                    $contentSid = $this->estimate_expiration_reminder_template_id;
                    $expiry_date = $estimate->expirydate;
                    $variables = [
                        "body_1" => $first_name,
                        "body_2" => $last_name,
                        "body_3" => $estimate_number,
                        "body_4" => $expiry_date,
                        "body_5" => $url
                    ];
                }

                $phone = $this->formatPhoneNumber($contact["phonenumber"]);
               
                $to = [$phone];
                //templateNameForMSG91 Changed name and create template estimate_send_to_customer
                $templateNameForMSG91 = $template_name !== 'estimate_send_to_customer'?"estimatewa":"estimate_echopxwa";
                
                $messagePayload = $this->messageUnit($templateNameForMSG91,$to,$variables);
             

                 
                $ch = curl_init();
                curl_setopt_array($ch, [
                    CURLOPT_URL => 'https://api.msg91.com/api/v5/whatsapp/whatsapp-outbound-message/bulk/',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => json_encode($messagePayload),
                    CURLOPT_HTTPHEADER => [
                        'Content-Type: application/json',
                        'authkey: 419920AGWjI9ahNn4766274beeP1',
                        'Cookie: PHPSESSID=q82npotm8s19dm9cdg1d09f3a2'
                    ],
                ]);

                $response = curl_exec($ch);
                curl_close($ch);

                $response_data = json_decode($response, true);
                $message_id = $response_data['request_id'] ?? '';

                $data = [
                    "mssg_id" => $message_id,
                    "template_name" => $template_text,
                    "rel_id" => $id,
                    "rel_type" => $rel_type,
                    "status" => $response_data['status'] ?? 'failed',
                    "to" => json_encode($to)
                ];

                add_wa_tracking($data);
            }
        }
    }

    public function send_to_wa_estimate_twilio() {
        $ids = $_POST['ids'];
        $template_name = $_POST['template_name'];
        $template_text = $_POST['template_text'];
        $rel_type = $_POST['rel_type'];
        $twilio = new Client($this->sid, $this->token);

        foreach ($ids as $id) {
            $estimate = $this->estimates_model->get($id);
            $client_id = $estimate->clientid;
            $contacts = $this->clients_model->get_contacts($client_id);

            foreach($contacts as $contact) {

                $first_name = $contact["firstname"];
                $last_name = $contact["lastname"];
                $estimate_number = format_estimate_number($estimate->id);
                $estimate_status = format_estimate_status($estimate->status, '', false);
                $url = site_url('estimate/' . $id . '/' . $estimate->hash);
                $phone = $contact["phonenumber"];
                if (substr($phone, 0, 3) !== '+91') {
                    $phone = '+91' . $phone;
                }

                $contentSid = $this->estimate_to_customer_template_id;
                $variables = [
                    "1" => $first_name,
                    "2" => $last_name,
                    "3" => $estimate_number,
                    "4" => $estimate_status,
                    "5" => $url
                ];
                if($template_name == 'estimate-expiry-reminder') {
                    $contentSid = $this->estimate_expiration_reminder_template_id;
                    $expiry_date = $estimate->expirydate;
                    $variables = [
                        "1" => $first_name,
                        "2" => $last_name,
                        "3" => $estimate_number,
                        "4" => $expiry_date,
                        "5" => $url
                    ];
                }



                $message = $twilio->messages
                ->create("whatsapp:{$phone}", // to
                            [
                                "contentSid" => $contentSid,
                                "from" => $this->mssg_service_id,
                                "contentVariables" => json_encode($variables)
                            ]
                );
                
                $data = [
                    "mssg_id" => $message->sid,
                    "template_name" => $template_text,
                    "rel_id" => $id,
                    "rel_type" => $rel_type,
                    "status" => $message->status,
                    "to" => $phone
                ];

                add_wa_tracking($data);
            }
        }

    }

    public function send_to_wa_invoice()
    {
        $ids = $_POST['ids'];
          $template_name = $_POST['template_name'];
          $template_text = $_POST['template_text'];
        $rel_type = $_POST['rel_type'];

        foreach ($ids as $id) {
            $invoice = $this->invoices_model->get($id);
            $client_id = $invoice->clientid;
            $contacts = $this->clients_model->get_contacts($client_id);

            foreach ($contacts as $contact) {

                $first_name = $contacts[0]["firstname"];
                $last_name = $contacts[0]["lastname"];
                $invoice_number = format_invoice_number($invoice->id);
                $invoice_status = format_invoice_status($invoice->status, '', false);
                $url = site_url('invoice/' . $id . '/' . $invoice->hash . '/'.$this->formatPhoneNumberFor10Digit($contact["phonenumber"]));

                $variables = [
                    "body_1" => $first_name,
                    "body_2" => $last_name,
                    "body_3" => $invoice_number,
                    "body_4" => $invoice_status,
                    "body_5" => $url
                ];

                if ($template_name == 'invoice_due_notice') {
                
                    $due_date = $invoice->duedate;
                    $variables = [
                        "body_1" => $first_name,
                        "body_2" => $last_name,
                        "body_3" => $invoice_number,
                        "body_4" => $due_date,
                        "body_5" => $url
                    ];
                }
                $phone = $this->formatPhoneNumber($contact["phonenumber"]);
               
                $to = [$phone];
                $templateNameForMSG91 = $template_name == 'invoice_due_notice'?"echopxwa":"echopxwainvoice";
                 
               


                $messagePayload = $this->messageUnit($templateNameForMSG91,$to,$variables);
                 $messagePayload1 = [ /// currently there is no use of $messagePayload1
                    "integrated_number" => "918494966977",
                    "content_type" => "template",
                    "payload" => [
                        "messaging_product" => "whatsapp",
                        "type" => "template",
                        "template" => [
                            "name" => $template_name,// Template Name
                            "language" => [
                                "code" => "en",
                                "policy" => "deterministic"
                            ],
                            "namespace" => null,
                            "to_and_components" => [
                                [
                                    "to" => $to,// phone number 
                                    "components" => [ // variable array
                                        "body_1" => [
                                            "type" => "text",
                                            "value" => $variables["body_1"] 
                                        ],
                                        "body_2" => [
                                            "type" => "text",
                                            "value" => $variables["body_2"]
                                        ],
                                        "body_3" => [
                                            "type" => "text",
                                            "value" => $variables["body_3"]
                                        ],
                                        "body_4" => [
                                            "type" => "text",
                                            "value" => $variables["body_4"]
                                        ],
                                        "body_5" => [
                                            "type" => "text",
                                            "value" => $variables["body_5"]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ]
                ];

                $ch = curl_init();
                curl_setopt_array($ch, [
                    CURLOPT_URL => 'https://api.msg91.com/api/v5/whatsapp/whatsapp-outbound-message/bulk/',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => json_encode($messagePayload),
                    CURLOPT_HTTPHEADER => [
                        'Content-Type: application/json',
                        'authkey: 419920AGWjI9ahNn4766274beeP1',
                        'Cookie: PHPSESSID=q82npotm8s19dm9cdg1d09f3a2'
                    ],
                ]);

                $response = curl_exec($ch);
                curl_close($ch);


                $response_data = json_decode($response, true);
                $message_id = $response_data['request_id'] ?? '';

                $data = [
                    "mssg_id" => $message_id,
                    "template_name" => $template_text,
                    "rel_id" => $id,
                    "rel_type" => $rel_type,
                    "status" => $response_data['status'] ?? 'failed',
                    "to" => json_encode($to)
                ];

                add_wa_tracking($data);
            }
        }
    }

    public function send_to_wa_invoice_twillio() {
        $ids = $_POST['ids'];
        $template_name = $_POST['template_name'];
        $template_text = $_POST['template_text'];
        $rel_type = $_POST['rel_type'];
        $twilio = new Client($this->sid, $this->token);

        foreach ($ids as $id) {
            $invoice = $this->invoices_model->get($id);
            $client_id = $invoice->clientid;
            $contacts = $this->clients_model->get_contacts($client_id);

            foreach($contacts as $contact) {

                $first_name = $contact["firstname"];
                $last_name = $contact["lastname"];
                $invoice_number = format_invoice_number($invoice->id);
                $invoice_status = format_invoice_status($invoice->status, '', false);
                $url = site_url('invoice/' . $id . '/' . $invoice->hash);
                $phone = $contact["phonenumber"];
                if (substr($phone, 0, 3) !== '+91') {
                    $phone = '+91' . $phone;
                }

                $contentSid = $this->invoice_to_customer_template_id;
                $variables = [
                    "1" => $first_name,
                    "2" => $last_name,
                    "3" => $invoice_number,
                    "4" => $invoice_status,
                    "5" => $url
                ];
                if($template_name == 'invoice-due-notice') {
                    $contentSid = $this->invoice_due_notice_template_id;
                    $due_date = $invoice->duedate;
                    $variables = [
                        "1" => $first_name,
                        "2" => $last_name,
                        "3" => $invoice_number,
                        "4" => $due_date,
                        "5" => $url
                    ];
                }



                $message = $twilio->messages
                ->create("whatsapp:{$phone}", // to
                            [
                                "contentSid" => $contentSid,
                                "from" => $this->mssg_service_id,
                                "contentVariables" => json_encode($variables)
                            ]
                );
                
                $data = [
                    "mssg_id" => $message->sid,
                    "template_name" => $template_text,
                    "rel_id" => $id,
                    "rel_type" => $rel_type,
                    "status" => $message->status,
                    "to" => $phone
                ];

                add_wa_tracking($data);
            }
        }
    }

    public function send_invoice_to_client($id, $template_name = '', $attachpdf = true, $cc = '', $manually = false, $attachStatement = [])

    {


        $invoice =  $this->invoices_model->get($id);

        $emails_sent = [];

        $send_to     = [];



        // Manually is used when sending the invoice via add/edit area button Save & Send

        $contacts = $this->get_contacts_for_invoice_emails($invoice->clientid);



        foreach ($contacts as $contact) {

            array_push($send_to, $contact['id']);

        }


        if (is_array($send_to) && count($send_to) > 0) {



            $status_updated = update_invoice_status($invoice->id, true, true);



            $invoice_number = format_invoice_number($invoice->id);



            if ($attachpdf) {

                set_mailing_constant();

                $pdf    = invoice_pdf($this->invoices_model->get($id));

                $attach = $pdf->Output($invoice_number . '.pdf', 'S');

            }



            $i = 0;

            foreach ($send_to as $contact_id) {

                if ($contact_id != '') {



                    // Send cc only for the first contact

                    if (!empty($cc) && $i > 0) {

                        $cc = '';

                    }



                    $contact = $this->clients_model->get_contact($contact_id);



                    if (!$contact) {

                        continue;

                    }



                    $template = mail_template($template_name, $invoice, $contact, $cc);



                    if ($attachpdf) {

                        $template->add_attachment([

                            'attachment' => $attach,

                            'filename'   => str_replace('/', '-', $invoice_number . '.pdf'),

                            'type'       => 'application/pdf',

                        ]);

                    }



                    if ($template->send()) {

                        $sent = true;

                        array_push($emails_sent, $contact->email);

                    }

                }

                $i++;

            }

        } 



        if (count($emails_sent) > 0) {

            $this->invoices_model->set_invoice_sent($id, false, $emails_sent, true);



            hooks()->do_action('invoice_sent', $id);



            return true;

        }



        return false;

    }


    protected function get_contacts_for_invoice_emails($client_id)

    {

        return $this->clients_model->get_contacts($client_id, [

            'active' => 1, 'invoice_emails' => 1,

        ]);

    }

}