<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Messaging Module 
Description: Email, SMS and Whatsapp Module For Perfex CRM
Version: 1.0.0
Requires at least: 2.3.*
*/

define('MESSAGING_MODULE_NAME', 'messaging');

hooks()->add_action('app_admin_head', 'message_load_js');
hooks()->add_action('app_admin_head', 'message_load_css');

register_activation_hook(MESSAGING_MODULE_NAME, 'messaging_module_activation_hook');

function messaging_module_activation_hook() {
	$CI = &get_instance();
	require_once __DIR__ . '/install.php';
}

$CI = &get_instance();
$CI->load->helper(MESSAGING_MODULE_NAME . '/messaging');


function message_load_js() {
    $viewuri = $_SERVER['REQUEST_URI'];
    if (!(strpos($viewuri, '/admin/proposals') === false)) {
        echo '<script src="' . module_dir_url(MESSAGING_MODULE_NAME, 'assets/js/proposal-message.js') .'"></script>';
        echo '<script src="' . module_dir_url(MESSAGING_MODULE_NAME, 'assets/js/proposal-tab.js') .'"></script>';
    }

    if (!(strpos($viewuri, '/admin/estimates') === false)) {
        echo '<script src="' . module_dir_url(MESSAGING_MODULE_NAME, 'assets/js/estimate-message.js') .'"></script>';
        echo '<script src="' . module_dir_url(MESSAGING_MODULE_NAME, 'assets/js/estimate-tab.js') .'"></script>';
    }

    if (!(strpos($viewuri, '/admin/invoices') === false)) {
        echo '<script src="' . module_dir_url(MESSAGING_MODULE_NAME, 'assets/js/invoice-message.js') .'"></script>';
        echo '<script src="' . module_dir_url(MESSAGING_MODULE_NAME, 'assets/js/invoice-tab.js') .'"></script>';
    }
}

function message_load_css() {
    $viewuri = $_SERVER['REQUEST_URI'];
    if (!(strpos($viewuri, '/admin/proposals') === false)) {
        echo '<link href="' . module_dir_url(MESSAGING_MODULE_NAME, 'assets/css/message.css') . '"  rel="stylesheet" type="text/css" />';
    }

    if (!(strpos($viewuri, '/admin/estimates') === false)) {
        echo '<link href="' . module_dir_url(MESSAGING_MODULE_NAME, 'assets/css/message.css') . '"  rel="stylesheet" type="text/css" />';
    }

    if (!(strpos($viewuri, '/admin/invoices') === false)) {
        echo '<link href="' . module_dir_url(MESSAGING_MODULE_NAME, 'assets/css/message.css') . '"  rel="stylesheet" type="text/css" />';
    }
}