<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Client extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('client_model');
    }

    // Info + "New" button page
    public function index()
    {
        $data['title'] = 'Client Management System';
        $data['clients'] = $this->client_model->get_all(); 
        $this->load->view('client/index', $data);



        
    }

    // Client form
    public function add()
    {
        if ($this->input->post()) {
            $insert_id = $this->client_model->insert($this->input->post());
            if ($insert_id) {
                set_alert('success', 'Client Added Successfully');
            } else {
                set_alert('error', 'Failed to Add Client');
            }
            redirect(admin_url('client'));
        }

        $data['title'] = 'Add Client';
        $this->load->view('client/add', $data);
    }
}
